/*
 * Decompiled with CFR 0.152.
 */
package frc.input;

import frc.emul.config.data.CfgItemController;
import frc.input.JInputComponent;
import frc.input.JInputManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.java.games.input.Component;
import net.java.games.input.Controller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JInputController {
    private final Controller controller;
    private final String ID;
    private final List<JInputComponent> allComps = new ArrayList<JInputComponent>();
    private final List<JInputComponent> axisAll = new ArrayList<JInputComponent>();
    private final List<JInputComponent> axisAnalog = new ArrayList<JInputComponent>();
    private final List<JInputComponent> axisDigital = new ArrayList<JInputComponent>();
    private final List<JInputComponent> buttons = new ArrayList<JInputComponent>();

    public JInputController(Controller controller) {
        this.controller = controller;
        this.ID = this.scrutinize();
    }

    public final String toString() {
        return " " + this.getName() + " ";
    }

    public final boolean isAvailable() {
        return JInputManager.getDefaultManager().contains(this);
    }

    public final List<JInputComponent> getAllAxis() {
        return this.axisAll;
    }

    public final List<JInputComponent> getAnalogAxis() {
        return this.axisAnalog;
    }

    public final List<JInputComponent> getDigitalAxis() {
        return this.axisDigital;
    }

    public final List<JInputComponent> getButtons() {
        return this.buttons;
    }

    public final List<JInputComponent> getComponents() {
        return this.allComps;
    }

    public final String getID() {
        return this.ID;
    }

    public final String getName() {
        return this.controller.getName();
    }

    public final Controller.Type getType() {
        return this.controller.getType();
    }

    public final JInputComponent getComponent(String string) {
        int n = 0;
        while (n < this.allComps.size()) {
            JInputComponent jInputComponent = this.allComps.get(n);
            if (jInputComponent.embodies(string)) {
                return jInputComponent;
            }
            ++n;
        }
        return null;
    }

    public final JInputComponent getNonNullComponent(String string) {
        JInputComponent jInputComponent = this.getComponent(string);
        return jInputComponent == null ? JInputComponent.createFake(this, string) : jInputComponent;
    }

    public final boolean embodies(Object object) {
        if (object instanceof JInputController) {
            return ((JInputController)object).controller.equals(this.controller);
        }
        if (object instanceof Controller) {
            return object.equals(this.controller);
        }
        if (object instanceof String) {
            return object.equals(this.ID);
        }
        return false;
    }

    public final boolean poll() {
        try {
            return this.controller.poll();
        }
        catch (Exception exception) {
            System.err.println("Error while polling controller \"" + this.getName() + "\" :");
            exception.printStackTrace(System.err);
            return false;
        }
    }

    public final CfgItemController getDefaults() {
        CfgItemController cfgItemController = new CfgItemController(this.getID());
        this.selectDefaultButtons(cfgItemController);
        this.selectDefaultAxis(cfgItemController, true);
        return cfgItemController;
    }

    public final void selectDefaultAxis(CfgItemController cfgItemController, boolean bl) {
        List<JInputComponent> list = this.getAnalogAxis();
        List<JInputComponent> list2 = this.getDigitalAxis();
        JInputComponent jInputComponent = JInputController.find(list, Component.Identifier.Axis.X);
        JInputComponent jInputComponent2 = JInputController.find(list, Component.Identifier.Axis.Y);
        if (jInputComponent != null && jInputComponent2 != null) {
            cfgItemController.dirMode = CfgItemController.DirControl.AXIS;
            cfgItemController.axisXID = jInputComponent.getID();
            cfgItemController.axisYID = jInputComponent2.getID();
            cfgItemController.invertX = false;
            cfgItemController.invertY = false;
            return;
        }
        JInputComponent jInputComponent3 = JInputController.find(list2, Component.Identifier.Axis.POV);
        if (jInputComponent3 != null) {
            cfgItemController.dirMode = CfgItemController.DirControl.POV;
            cfgItemController.povID = jInputComponent3.getID();
            return;
        }
        if (list.size() >= 2) {
            cfgItemController.dirMode = CfgItemController.DirControl.AXIS;
            cfgItemController.axisXID = list.get(0).getID();
            cfgItemController.axisYID = list.get(1).getID();
            cfgItemController.invertX = false;
            cfgItemController.invertY = false;
            return;
        }
        if (this.getButtons().size() >= 4) {
            String[] stringArray = this.getDefaultButtonIDs();
            cfgItemController.dirMode = CfgItemController.DirControl.BTNS;
            if (bl && this.getButtons().size() >= 8) {
                String string = cfgItemController.buttonID[0];
                String string2 = cfgItemController.buttonID[1];
                String string3 = cfgItemController.buttonID[2];
                String string4 = cfgItemController.buttonID[3];
                int n = 0;
                int n2 = 0;
                block6: while (true) {
                    String string5;
                    if ((string5 = stringArray[n++]).equals(string) || string5.equals(string2) || string5.equals(string3) || string5.equals(string4)) {
                        continue;
                    }
                    switch (n2++) {
                        case 0: {
                            cfgItemController.leftID = string5;
                            continue block6;
                        }
                        case 1: {
                            cfgItemController.downID = string5;
                            continue block6;
                        }
                        case 2: {
                            cfgItemController.rightID = string5;
                            continue block6;
                        }
                        case 3: {
                            cfgItemController.upID = string5;
                            return;
                        }
                    }
                }
            }
            cfgItemController.leftID = stringArray[0];
            cfgItemController.downID = stringArray[1];
            cfgItemController.rightID = stringArray[2];
            cfgItemController.upID = stringArray[3];
            return;
        }
        cfgItemController.dirMode = CfgItemController.DirControl.UNDEFINED;
    }

    public final void selectDefaultButtons(CfgItemController cfgItemController) {
        this.selectDefaultButtons(cfgItemController.buttonID);
    }

    public final void selectDefaultButtons(String[] stringArray) {
        boolean bl = true;
        JInputComponent[] jInputComponentArray = new JInputComponent[]{JInputController.find(this.buttons, Component.Identifier.Button._0), JInputController.find(this.buttons, Component.Identifier.Button._1), JInputController.find(this.buttons, Component.Identifier.Button._2), JInputController.find(this.buttons, Component.Identifier.Button._3)};
        int n = 4;
        while (n-- > 0 && bl) {
            JInputComponent jInputComponent = jInputComponentArray[n];
            if (jInputComponent == null) {
                bl = false;
                continue;
            }
            stringArray[n] = jInputComponent.getID();
        }
        if (!bl) {
            this.getDefaultButtonIDs(stringArray);
        }
    }

    public static final JInputComponent find(List<JInputComponent> list, Object object) {
        for (JInputComponent jInputComponent : list) {
            if (!jInputComponent.embodies(object)) continue;
            return jInputComponent;
        }
        return null;
    }

    public static final int indexOf(List<JInputComponent> list, Object object) {
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            if (list.get(n2).embodies(object)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private final String[] getDefaultButtonIDs() {
        String[] stringArray = new String[4];
        this.getDefaultButtonIDs(stringArray);
        return stringArray;
    }

    private final void getDefaultButtonIDs(String[] stringArray) {
        assert (stringArray.length == 4);
        List<JInputComponent> list = this.getButtons();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(4);
        arrayList.add(new Integer(JInputController.indexOf(list, Component.Identifier.Button._0)));
        arrayList.add(new Integer(JInputController.indexOf(list, Component.Identifier.Button._1)));
        arrayList.add(new Integer(JInputController.indexOf(list, Component.Identifier.Button._2)));
        arrayList.add(new Integer(JInputController.indexOf(list, Component.Identifier.Button._3)));
        int n = 0;
        while (n < 4) {
            int n2 = (Integer)arrayList.get(n);
            if (n2 >= 0) {
                stringArray[n] = list.get(n2).getID();
            } else {
                n2 = 0;
                while (n2 < list.size()) {
                    Integer n3 = new Integer(n2);
                    if (arrayList.indexOf(n3) < 0) {
                        arrayList.add(n3);
                        stringArray[n] = list.get(n2).getID();
                        break;
                    }
                    ++n2;
                }
                if (stringArray[n] == null) {
                    if (n > 0) {
                        stringArray[n] = stringArray[n - 1];
                    } else if (list.size() > 0) {
                        stringArray[n] = list.get(list.size() - 1).getID();
                    }
                }
            }
            ++n;
        }
    }

    private final String scrutinize() {
        Object object;
        Component[] componentArray = this.controller.getComponents();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < componentArray.length) {
            object = new JInputComponent(this, componentArray[n5]);
            Component.Identifier identifier = ((JInputComponent)object).getType();
            String string = identifier.getClass().getName();
            boolean c = ((JInputComponent)object).isAnalog();
            boolean bl = ((JInputComponent)object).isRelative();
            if (string.indexOf("$Axis") >= 0) {
                ++n;
                this.axisAll.add((JInputComponent)object);
                if (c) {
                    this.axisAnalog.add((JInputComponent)object);
                } else {
                    this.axisDigital.add((JInputComponent)object);
                }
            } else if (string.indexOf("$Button") >= 0) {
                ++n2;
                this.buttons.add((JInputComponent)object);
            }
            this.allComps.add((JInputComponent)object);
            if (bl) {
                ++n4;
            }
            if (c) {
                ++n3;
            }
            ++n5;
        }
        this.enforceUniqueIDS();
        StringBuffer stringBuffer = new StringBuffer(100);
        object = this.controller.getName();
        int n6 = ((String)object).length();
        int n7 = 0;
        while (n7 < n6) {
            char c = ((String)object).charAt(n7);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                stringBuffer.append(c);
            } else if (c == ' ' || c == '.' || c == '_' || c == '-') {
                stringBuffer.append('_');
            }
            ++n7;
        }
        stringBuffer.append('_').append(this.controller.getRumblers().length).append(this.controller.getControllers().length).append(componentArray.length).append(n4).append(n3).append(n).append(n2);
        return stringBuffer.toString();
    }

    private final void enforceUniqueIDS() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
        Integer n = new Integer(1);
        for (JInputComponent jInputComponent : this.allComps) {
            int n2;
            String string = jInputComponent.getID();
            Integer n3 = (Integer)hashMap.get(string);
            if (n3 == null) {
                hashMap.put(string, n);
            } else {
                n2 = n3 + 1;
                hashMap.put(string, n2);
                jInputComponent.setID(String.valueOf(string) + "#" + n2);
            }
            string = jInputComponent.getName();
            n3 = (Integer)hashMap2.get(string);
            if (n3 == null) {
                hashMap2.put(string, n);
                continue;
            }
            n2 = n3 + 1;
            hashMap2.put(string, n2);
            jInputComponent.setName(String.valueOf(string) + " (" + n2 + ")");
        }
    }
}

